/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.item;

import com.min01.archaeology.block.BrushableBlock;
import com.min01.archaeology.blockentity.BrushableBlockEntity;
import com.min01.archaeology.init.ArchaeologyArmPose;
import com.min01.archaeology.init.ArchaeologySounds;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;
    private static final double MAX_BRUSH_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public BrushItem(Item.Properties p_272907_) {
        super(p_272907_);
    }

    public InteractionResult m_6225_(UseOnContext p_272607_) {
        Player player = p_272607_.m_43723_();
        if (player != null && this.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.BLOCK) {
            player.m_6672_(p_272607_.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim m_6164_(ItemStack p_273490_) {
        return UseAnim.CUSTOM;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.m_6117_() && player.m_21212_() > 0) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
                    float f = player.m_21212_() % 10;
                    float f1 = f - partialTick + 1.0f;
                    float f2 = 1.0f - f1 / 10.0f;
                    float f7 = -15.0f + 75.0f * Mth.m_14089_((float)(f2 * 2.0f * (float)Math.PI));
                    if (arm != HumanoidArm.RIGHT) {
                        poseStack.m_85837_(0.1, 0.83, 0.35);
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-80.0f));
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f7));
                        poseStack.m_85837_(-0.3, 0.22, 0.35);
                    } else {
                        poseStack.m_85837_(-0.25, 0.22, 0.35);
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-80.0f));
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(0.0f));
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f7));
                    }
                }
                return false;
            }

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return ArchaeologyArmPose.BRUSH;
            }
        });
    }

    public int m_8105_(ItemStack p_272765_) {
        return 200;
    }

    public void m_5929_(Level p_273467_, LivingEntity p_273619_, ItemStack p_273316_, int p_273101_) {
        if (p_273101_ >= 0 && p_273619_ instanceof Player) {
            Player player = (Player)p_273619_;
            HitResult hitresult = this.calculateHitResult(p_273619_);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.m_8105_(p_273316_) - p_273101_ + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        BrushableBlockEntity brushableblockentity;
                        boolean flag1;
                        BlockEntity blockentity;
                        SoundEvent soundevent;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = p_273467_.m_8055_(blockpos);
                        HumanoidArm humanoidarm = p_273619_.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        this.spawnDustParticles(p_273467_, blockhitresult, blockstate, p_273619_.m_20252_(0.0f), humanoidarm);
                        Block $$18 = blockstate.m_60734_();
                        if ($$18 instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)$$18;
                            soundevent = brushableblock.getBrushSound();
                        } else {
                            soundevent = (SoundEvent)ArchaeologySounds.BRUSH_GENERIC.get();
                        }
                        p_273467_.m_5594_(player, blockpos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!p_273467_.m_5776_() && (blockentity = p_273467_.m_7702_(blockpos)) instanceof BrushableBlockEntity && (flag1 = (brushableblockentity = (BrushableBlockEntity)blockentity).brush(p_273467_.m_46467_(), player, blockhitresult.m_82434_()))) {
                            EquipmentSlot equipmentslot = p_273316_.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            p_273316_.m_41622_(1, p_273619_, p_279044_ -> p_279044_.m_21166_(equipmentslot));
                        }
                    }
                    return;
                }
            }
            p_273619_.m_21253_();
        } else {
            p_273619_.m_21253_();
        }
    }

    private HitResult calculateHitResult(LivingEntity p_281264_) {
        return BrushItem.getHitResultOnViewVector((Entity)p_281264_, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), MAX_BRUSH_DISTANCE);
    }

    public static HitResult getHitResultOnViewVector(Entity p_278281_, Predicate<Entity> p_278306_, double p_278293_) {
        Vec3 vec3 = p_278281_.m_20252_(0.0f).m_82490_(p_278293_);
        Level level = p_278281_.f_19853_;
        Vec3 vec31 = p_278281_.m_146892_();
        return BrushItem.getHitResult(vec31, p_278281_, p_278306_, vec3, level);
    }

    private static HitResult getHitResult(Vec3 p_278237_, Entity p_278320_, Predicate<Entity> p_278257_, Vec3 p_278342_, Level p_278321_) {
        EntityHitResult hitresult1;
        Vec3 vec3 = p_278237_.m_82549_(p_278342_);
        BlockHitResult hitresult = p_278321_.m_45547_(new ClipContext(p_278237_, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_278320_));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec3 = hitresult.m_82450_();
        }
        if ((hitresult1 = ProjectileUtil.m_37304_((Level)p_278321_, (Entity)p_278320_, (Vec3)p_278237_, (Vec3)vec3, (AABB)p_278320_.m_20191_().m_82369_(p_278342_).m_82400_(1.0), p_278257_)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public void spawnDustParticles(Level p_278327_, BlockHitResult p_278272_, BlockState p_278235_, Vec3 p_278337_, HumanoidArm p_285071_) {
        double d0 = 3.0;
        int i = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int j = p_278327_.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.f_123794_, p_278235_);
        Direction direction = p_278272_.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(p_278337_, direction);
        Vec3 vec3 = p_278272_.m_82450_();
        for (int k = 0; k < j; ++k) {
            p_278327_.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 p_273421_, Direction p_272987_) {
            double d0 = 0.0;
            return switch (p_272987_) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.m_7094_(), 0.0, -p_273421_.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

